/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.ventas;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.compras.FormaPago;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Compensacion;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Venta;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.ats.modelo.util.ValidadorCompensaciones;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComprobanteVenta
extends ObjetoModeloSucesorValidableAnotado<Venta>
implements InformacionEditable<ComprobanteVenta>,
Exportable,
Importable {
    private ValidadorCompensaciones validadorCompensaciones = new ValidadorCompensaciones();
    private static final String TIPO_EMISION = "tipoEmision";
    private static final String COMPENSACIONES = "compensaciones";
    private static final long serialVersionUID = -4374534461631577054L;
    private static final String FORMAS_COBRO = "formasCobro";
    public static final String C_TIPO_COMPROBANTE = "tipoComprobante";
    public static final String C_NUMERO_EMITIDOS = "numeroEmitidos";
    public static final String C_BASE_IVA_CERO = "baseIvaCero";
    public static final String C_BASE_IVA_NO_CERO = "baseIvaNoCero";
    public static final String C_MONTO_IVA = "montoIva";
    public static final String C_MONTO_ICE = "montoIce";
    public static final String C_BASE_NO_IVA = "baseNoIva";
    public static final String C_IVA_RETENIDO = "ivaRetenido";
    public static final String C_IR_RETENIDO = "irRetenido";
    private static final String M_NUMERO_EMITIDOS = "El valor No. Comprobantes Emitidos";
    private BigDecimal totalComprobante;
    @NotNull(message="Debe seleccionar el tipo de Comprobante")
    private String tipoComprobante;
    private String descripcionTipoComprobante;
    private String tipoEmision = "F";
    @NotNull(message="Debe ingresar el valor de El valor No. Comprobantes Emitidos")
    @Pattern(regexp="\\d{1,12}", message="El valor No. Comprobantes Emitidos debe ser solo n\u00fameros. ")
    private String numeroEmitidos = "0";
    @NotNull(message="Debe ingresar el valor de Tarifa IVA 0% ")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Tarifa IVA 0%  debe ser 12 enteros y 2 decimales. ")
    private String baseIvaCero = "0.00";
    @NotNull(message="Debe ingresar el valor de Tarifa IVA diferente de 0%")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Tarifa IVA diferente de 0% debe ser 12 enteros y 2 decimales. ")
    private String baseIvaNoCero = "0.00";
    @NotNull(message="Debe ingresar el valor de Monto IVA")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Monto IVA debe ser 12 enteros y 2 decimales. ")
    private String montoIva = "0.00";
    @NotNull(message="Debe ingresar el valor de No objeto de IVA")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor No objeto de IVA debe ser 12 enteros y 2 decimales. ")
    private String baseNoIva = "0.00";
    @NotNull(message="Debe ingresar el valor de Valor Retenido IVA")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Valor Retenido IVA debe ser 12 enteros y 2 decimales. ")
    private String ivaRetenido = "0.00";
    @NotNull(message="Debe ingresar el valor de Valor Retenido Renta")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Valor Retenido Renta debe ser 12 enteros y 2 decimales. ")
    private String irRetenido = "0.00";
    @NotNull(message="Debe ingresar el valor de Monto ICE")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Monto ICE debe ser 12 enteros y 2 decimales. ")
    private String montoIce = "0.00";
    private final List<FormaPago> formasCobro;
    private final List<Compensacion> compensaciones;
    private BigDecimal montoIvaCalculado = new BigDecimal("0.00");
    private boolean modificaIva;

    public ComprobanteVenta() {
        this.totalComprobante = new BigDecimal("0.00");
        this.formasCobro = new ArrayList<FormaPago>();
        this.compensaciones = new ArrayList<Compensacion>();
    }

    public ComprobanteVenta crearCopiaEdicion() {
        ComprobanteVenta copia = new ComprobanteVenta();
        copia.setPropietario((ObjetoModelo)((Venta)this.propietario));
        copia.setBaseIvaCero(this.baseIvaCero);
        copia.setBaseIvaNoCero(this.baseIvaNoCero);
        copia.setBaseNoIva(this.baseNoIva);
        copia.setDescripcionTipoComprobante(this.descripcionTipoComprobante);
        copia.setIrRetenido(this.irRetenido);
        copia.setIvaRetenido(this.ivaRetenido);
        copia.setMontoIva(this.montoIva);
        copia.setNumeroEmitidos(this.numeroEmitidos);
        copia.setTipoComprobante(this.tipoComprobante);
        copia.setTotalComprobante(this.totalComprobante);
        copia.setMontoIce(this.montoIce);
        copia.getFormasCobro().addAll(this.getFormasCobro());
        copia.getCompensaciones().addAll(this.getCompensaciones());
        copia.setTipoEmision(this.tipoEmision);
        copia.setPropietario((ObjetoModelo)((Venta)this.propietario));
        return copia;
    }

    public void actualizarInformacion(ComprobanteVenta copiaEdicion) {
        this.setBaseIvaCero(copiaEdicion.getBaseIvaCero());
        this.setBaseIvaNoCero(copiaEdicion.getBaseIvaNoCero());
        this.setBaseNoIva(copiaEdicion.getBaseNoIva());
        this.setDescripcionTipoComprobante(copiaEdicion.getDescripcionTipoComprobante());
        this.setIrRetenido(copiaEdicion.getIrRetenido());
        this.setIvaRetenido(copiaEdicion.getIvaRetenido());
        this.setMontoIva(copiaEdicion.getMontoIva());
        this.setMontoIce(copiaEdicion.getMontoIce());
        this.setNumeroEmitidos(copiaEdicion.getNumeroEmitidos());
        this.setTipoComprobante(copiaEdicion.getTipoComprobante());
        this.setTotalComprobante(copiaEdicion.getTotalComprobante());
        this.getFormasCobro().clear();
        this.getFormasCobro().addAll(copiaEdicion.getFormasCobro());
        this.getCompensaciones().clear();
        this.getCompensaciones().addAll(copiaEdicion.getCompensaciones());
        this.setTipoEmision(copiaEdicion.getTipoEmision());
    }

    public ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        this.validadorCompensaciones.validarCompensaciones(resultado, this.baseIvaNoCero, this.compensaciones, ((Iva)this.getRaizModelo()).periodo);
        this.validarMontoIvaIce(resultado);
        this.validarMontoRetenidoDeIva(resultado);
        return resultado.esEstadoExitoso() ? resultado.pasarValidacion() : resultado;
    }

    private void validarMontoRetenidoDeIva(ResultadoValidacion resultado) {
    }

    protected void validacionAnotadaExitosa() {
        this.calcularMontoIva();
        this.calcularTotalComprobante();
    }

    private void calcularMontoIva() {
        this.montoIvaCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getBaseIvaNoCero()), ((Iva)this.getRaizModelo()).getPorcentajeIva());
        if (!this.isModificaIva()) {
            this.setMontoIva(String.valueOf(this.montoIvaCalculado));
        }
    }

    public boolean isModificaIva() {
        return this.modificaIva;
    }

    public void setModificaIva(boolean modificaIva) {
        this.modificaIva = modificaIva;
    }

    private ResultadoValidacion validarMontoIvaIce(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getMontoIva()).compareTo(Util.getBigDecimal(this.getBaseIvaNoCero())) == 1) {
            return resultado.fallarValidacion("El valor Monto Iva no puede ser mayor al valor Tarifa IVA diferente de 0%");
        }
        if (Util.getBigDecimal(this.getMontoIce()).compareTo(Util.getBigDecimal(this.getBaseIvaNoCero())) == 1) {
            return resultado.fallarValidacion("El valor Monto Ice no puede ser mayor al valor Tarifa IVA diferente de 0%");
        }
        return resultado;
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName(C_TIPO_COMPROBANTE);
        Element eValor = (Element)valorList.item(0);
        this.tipoComprobante = eValor.getTextContent().trim();
        this.descripcionTipoComprobante = this.getTipoComprobante().concat("-").concat(UtilCatalogosATS.crearInstancia().obtenerDescripcionComprobante(this.getTipoComprobante()));
        if (Util.existeElementoImportar(elemento, TIPO_EMISION)) {
            valorList = elemento.getElementsByTagName(TIPO_EMISION);
            eValor = (Element)valorList.item(0);
            this.tipoEmision = eValor.getTextContent().trim();
        }
        valorList = elemento.getElementsByTagName("numeroComprobantes");
        eValor = (Element)valorList.item(0);
        this.numeroEmitidos = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("baseNoGraIva");
        eValor = (Element)valorList.item(0);
        this.baseNoIva = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("baseImponible");
        eValor = (Element)valorList.item(0);
        this.baseIvaCero = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("baseImpGrav");
        eValor = (Element)valorList.item(0);
        this.baseIvaNoCero = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName(C_MONTO_IVA);
        eValor = (Element)valorList.item(0);
        this.montoIva = eValor.getTextContent().trim();
        this.importarCompensacionesDesdeJunio2016(elemento);
        valorList = elemento.getElementsByTagName("valorRetIva");
        eValor = (Element)valorList.item(0);
        this.ivaRetenido = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("valorRetRenta");
        eValor = (Element)valorList.item(0);
        this.irRetenido = eValor.getTextContent().trim();
        if (Util.existeElementoImportar(elemento, C_MONTO_ICE)) {
            valorList = elemento.getElementsByTagName(C_MONTO_ICE);
            eValor = (Element)valorList.item(0);
            this.montoIce = eValor.getTextContent().trim();
        }
        valorList = elemento.getElementsByTagName("formaPago");
        int i = 0;
        while (i < valorList.getLength()) {
            Node nodo = valorList.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                FormaPago formaPago = new FormaPago();
                formaPago.importar(elem, null);
                this.agregarFormasCobro(formaPago);
            }
            ++i;
        }
        return this;
    }

    private void importarCompensacionesDesdeJunio2016(Element elemento) {
        NodeList compensaciones = elemento.getElementsByTagName("compensacion");
        int numeroNodo = 0;
        while (numeroNodo < compensaciones.getLength()) {
            Node nodo = compensaciones.item(numeroNodo);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                Compensacion compensacion = new Compensacion();
                compensacion.importar(elem, null);
                this.agregarCompensacion(compensacion);
            }
            ++numeroNodo;
        }
    }

    public Element exportar(Document documento, Element elemento) {
        Periodo periodo = ((Iva)((Venta)this.getPropietario()).getRaizModelo()).periodo;
        Element tagVenta = documento.createElement("detalleVentas");
        this.exportarComprador(documento, tagVenta);
        Element emDv = documento.createElement(C_TIPO_COMPROBANTE);
        emDv.setTextContent(this.getTipoComprobante());
        tagVenta.appendChild(emDv);
        emDv = documento.createElement(TIPO_EMISION);
        emDv.setTextContent(this.getTipoEmision());
        tagVenta.appendChild(emDv);
        emDv = documento.createElement("numeroComprobantes");
        emDv.setTextContent(this.getNumeroEmitidos());
        tagVenta.appendChild(emDv);
        this.exportarBasesImponibles(documento, tagVenta);
        this.exportarMontoIVA(documento, tagVenta);
        this.exportarCompensacionesDesdeMayo2016(documento, tagVenta, periodo);
        this.exportarMontoICEDesdeMarzo2015(documento, tagVenta, periodo);
        this.exportarValoresRetenidos(documento, tagVenta);
        this.exportarFormasDeCobroDesdeMayo2016(documento, tagVenta, periodo);
        return tagVenta;
    }

    private void exportarFormasDeCobroDesdeMayo2016(Document documento, Element tagVenta, Periodo periodo) {
        if (periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            Element formaPago = documento.createElement("formasDePago");
            for (FormaPago formaDeCobro : this.getFormasCobro()) {
                formaPago.appendChild(formaDeCobro.exportar(documento, null));
            }
            tagVenta.appendChild(formaPago);
        }
    }

    private void exportarMontoICEDesdeMarzo2015(Document documento, Element eleDtVts, Periodo periodo) {
        if (periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            Element emDv = documento.createElement(C_MONTO_ICE);
            emDv.setTextContent(this.getMontoIce());
            eleDtVts.appendChild(emDv);
        }
    }

    private void exportarCompensacionesDesdeMayo2016(Document documento, Element tagVenta, Periodo periodo) {
        if (periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            Element compensaciones = documento.createElement(COMPENSACIONES);
            for (Compensacion compensacion : this.getCompensaciones()) {
                compensaciones.appendChild(compensacion.exportar(documento, null));
            }
            tagVenta.appendChild(compensaciones);
        }
    }

    private void exportarValoresRetenidos(Document documento, Element eleDtVts) {
        Element emDv = documento.createElement("valorRetIva");
        emDv.setTextContent(this.getIvaRetenido());
        eleDtVts.appendChild(emDv);
        emDv = documento.createElement("valorRetRenta");
        emDv.setTextContent(this.getIrRetenido());
        eleDtVts.appendChild(emDv);
    }

    private void exportarMontoIVA(Document documento, Element eleDtVts) {
        Element emDv = documento.createElement(C_MONTO_IVA);
        emDv.setTextContent(this.getMontoIva());
        eleDtVts.appendChild(emDv);
    }

    private void exportarComprador(Document documento, Element eleDtVts) {
        ((Venta)this.getPropietario()).getComprador().exportar(documento, eleDtVts);
    }

    private void exportarBasesImponibles(Document documento, Element eleDtVts) {
        Element emDv = documento.createElement("baseNoGraIva");
        emDv.setTextContent(this.getBaseNoIva());
        eleDtVts.appendChild(emDv);
        emDv = documento.createElement("baseImponible");
        emDv.setTextContent(this.getBaseIvaCero());
        eleDtVts.appendChild(emDv);
        emDv = documento.createElement("baseImpGrav");
        emDv.setTextContent(this.getBaseIvaNoCero());
        eleDtVts.appendChild(emDv);
    }

    public String getTipoComprobante() {
        return this.tipoComprobante;
    }

    public String getDescripcionTipoComprobante() {
        return this.descripcionTipoComprobante;
    }

    public String getNumeroEmitidos() {
        return this.numeroEmitidos;
    }

    public String getBaseIvaCero() {
        return this.baseIvaCero;
    }

    public String getBaseIvaNoCero() {
        return this.baseIvaNoCero;
    }

    public String getMontoIva() {
        return this.montoIva;
    }

    public String getMontoIce() {
        return this.montoIce;
    }

    public String getBaseNoIva() {
        return this.baseNoIva;
    }

    public String getIvaRetenido() {
        return this.ivaRetenido;
    }

    public String getIrRetenido() {
        return this.irRetenido;
    }

    public String getTipoEmision() {
        return this.tipoEmision;
    }

    public void setTipoEmision(String tipoEmision) {
        String oldValue = this.tipoEmision;
        this.tipoEmision = tipoEmision;
        this.firePropertyChange(TIPO_EMISION, oldValue, this.tipoEmision);
    }

    public void agregarFormasCobro(FormaPago formaPago) {
        formaPago.setPropietario((ObjetoModelo)this);
        this.formasCobro.add(formaPago);
        this.firePropertyChange(FORMAS_COBRO, null, this.formasCobro);
    }

    public boolean eliminarFormasCobro(FormaPago formaPago) {
        boolean eliminado = this.formasCobro.remove((Object)formaPago);
        if (eliminado) {
            this.firePropertyChange(FORMAS_COBRO, null, this.formasCobro);
        }
        return eliminado;
    }

    public void agregarCompensacion(Compensacion compensacion) {
        compensacion.setPropietario((ObjetoModelo)this);
        this.compensaciones.add(compensacion);
        this.firePropertyChange(COMPENSACIONES, null, this.compensaciones);
    }

    public boolean eliminarCompensaciones(Compensacion compensacion) {
        boolean eliminado = this.compensaciones.remove((Object)compensacion);
        if (eliminado) {
            this.firePropertyChange(COMPENSACIONES, null, this.compensaciones);
        }
        return eliminado;
    }

    public void setTipoComprobante(String tipoComprobante) {
        String oldValue = this.tipoComprobante;
        this.tipoComprobante = tipoComprobante;
        this.firePropertyChange(C_TIPO_COMPROBANTE, oldValue, this.tipoComprobante);
    }

    public void setDescripcionTipoComprobante(String descripcionTipoComprobante) {
        this.descripcionTipoComprobante = descripcionTipoComprobante;
    }

    public void setNumeroEmitidos(String numeroEmitidos) {
        String oldValue = this.numeroEmitidos;
        this.numeroEmitidos = StringUtil.isNullOrEmpty((String)numeroEmitidos) ? null : numeroEmitidos;
        this.firePropertyChange(C_NUMERO_EMITIDOS, oldValue, this.numeroEmitidos);
    }

    public void setBaseIvaCero(String baseIvaCero) {
        String oldValue = this.baseIvaCero;
        this.baseIvaCero = baseIvaCero;
        this.firePropertyChange(C_BASE_IVA_CERO, oldValue, this.baseIvaCero);
    }

    public void setBaseIvaNoCero(String baseIvaNoCero) {
        String oldValue = this.baseIvaNoCero;
        this.baseIvaNoCero = baseIvaNoCero;
        this.firePropertyChange(C_BASE_IVA_NO_CERO, oldValue, this.baseIvaNoCero);
    }

    public void setMontoIva(String montoIva) {
        String oldValue = this.montoIva;
        this.montoIva = montoIva;
        this.firePropertyChange(C_MONTO_IVA, oldValue, this.montoIva);
    }

    public void setMontoIce(String montoIce) {
        String oldValue = this.montoIce;
        this.montoIce = montoIce;
        this.firePropertyChange(C_MONTO_ICE, oldValue, this.montoIce);
    }

    public void setBaseNoIva(String baseNoIva) {
        String oldValue = this.baseNoIva;
        this.baseNoIva = baseNoIva;
        this.firePropertyChange(C_BASE_NO_IVA, oldValue, this.baseNoIva);
    }

    public void setIvaRetenido(String ivaRetenido) {
        String oldValue = this.ivaRetenido;
        this.ivaRetenido = ivaRetenido;
        this.firePropertyChange(C_IVA_RETENIDO, oldValue, this.ivaRetenido);
    }

    public void setIrRetenido(String irRetenido) {
        String oldValue = this.irRetenido;
        this.irRetenido = irRetenido;
        this.firePropertyChange(C_IR_RETENIDO, oldValue, this.irRetenido);
    }

    public void setTotalComprobante(BigDecimal totalComprobante) {
        this.totalComprobante = totalComprobante;
    }

    public List<FormaPago> getFormasCobro() {
        return this.formasCobro;
    }

    public List<Compensacion> getCompensaciones() {
        return this.compensaciones;
    }

    public BigDecimal getTotalComprobante() {
        return this.totalComprobante;
    }

    public void calcularTotalComprobante() {
        this.totalComprobante = Util.sumarValores(this.getBaseIvaCero(), this.getBaseNoIva(), this.getBaseIvaNoCero());
    }
}

